

package gov.va.med.cds.request;


import gov.va.med.cds.clinicaldata.Operation;


/**
 * 
 * Place holder for the request (CUAD) xml and request type.
 * 
 */
public interface WriteRequestInterface
{
    /**
     * Sets the request id.
     * 
     * @param aRequestId Request Id.
     */
    void setRequestId( String aRequestId );


    /**
     * Sets the template id.
     * 
     * @param aTemplateId Template Id.
     */
    void setTemplateId( String aTemplateId );


    /**
     * Sets the CUAD request xml.
     * 
     * @param aRequestData Request xml.
     */
    void setRequestData( String aRequestData );


    /**
     * Gets the CUAD request xml.
     * 
     * @return Request xml.
     */
    String getRequestData( );


    /**
     * Gets the request id.
     * 
     * @return String request Id
     */
    String getRequestId( );


    /**
     * Gets the template id.
     * 
     * @return String template Id
     */
    String getTemplateId( );


    /**
     * Gets the request type - Create/update/append/delete.
     * 
     * @return Request type
     */
    Operation getOperation( );


    /**
     * Sets the request type - Create/update/append/delete.
     * 
     * @param operation Request type.
     */
    void setOperation( Operation operation );
}
