

package gov.va.med.cds.persistence.hibernate.common;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;


public class VistaPointInTimeUserTypeQueryNoTimezone
    extends
        VistaPointInTimeUserTypeQuery
{
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner )
        throws HibernateException,
            SQLException
    {
        String rawDate = rs.getString( names[0] );
        String namespace = rs.getString( names[1] );

        if ( rawDate == null )
        {
            return null;
        }

        String timestamp = null;
        if ( rawDate.indexOf( "-" ) > 0 )
        {
            timestamp = formatHdrTime( rawDate, namespace );
        }
        else
        {
            timestamp = formatVistaTime( rawDate, namespace );
        }

       	gov.va.med.cds.template.generated.basedatatypes.PointInTime pointInTime = null;
            if ( !rs.wasNull() )
            {
                pointInTime = new gov.va.med.cds.template.generated.basedatatypes.PointInTime();
                pointInTime.setLiteral(timestamp );
            }
            return pointInTime;
        
        
    }


    /**
     * builds the new date string from the historical date format to match HDR2.
     *  
     *  Historical Date Conversion: 
     *  
     *  Input                       Converted Output
     *  0                           - 0
     *  308                         - 20080000
     *  3081219                     - 20081219
     *  30812191219                 - 20081219
     *  3081219.170515              - 20081219170515
     *  30812191219.170515          - 20081219170515    
     *  
     *  Rules:
     *  Date not all numeric or Date length < 3 -- returns unconverted value
     *  Date length > 3 and date length < 7 -- adds 1700 to year and pads with zeros to make length 7
     *  Date length >= 7 -- adds 1700 to year and ignores characters beyond 7
     *  
     *  Time always attached to converted date (No offset as time is numeric)
     * 
     * @param vistaDate
     * @return builds the date string to match HDR2 
     */
    protected String formatVistaTime( String vistaDate, String namespace )
    {
        String retVal = null;

        if ( vistaDate != null && vistaDate.length() >= 3 )
        {
            // trim off the time
            //            String[] dateTime = vistaDate.split( "\\." );
            String[] dateTime = vistaDate.split( "[.^]+" );
            vistaDate = dateTime[0];

            // Filter out non-conformant string dates
            if ( isNonConformatString( vistaDate ) )
            {
                return vistaDate;
            }

            // split the time up into date and time parts.
            int dateMaxIndex = ( vistaDate.length() >= 7 ) ? 7 : vistaDate.length();
            String datePart = vistaDate.substring( 0, dateMaxIndex ) + "0000".substring( 0, 7 - dateMaxIndex );

            // add 1700 from the year to match Cache date format
            datePart = ( Integer.parseInt( datePart.substring( 0, 3 ) ) + 1700 ) + datePart.substring( 3 );
            retVal = datePart;

            int timeLength = dateTime.length > 2 ? dateTime[1].length() : 0;
            String timePart = ( timeLength > 0 ) ? dateTime[1].concat( "000000".substring( 0, 6 - timeLength ) ) : "";

            // build the new return string from date and time parts
            retVal = datePart + timePart;
        }
        else
        {
            retVal = vistaDate;
        }

        return retVal;
    }


    protected String formatHdrTime( String rawDate, String namespace )
    {
        if ( rawDate == null )
            return null;

        // trim off the nano-seconds
        String[] dateTime = rawDate.split( "\\." );
        String dtTime = dateTime[0];
        String retVal = dtTime.replaceAll( "[- :]", "" );

        int dateMaxIndex = ( retVal.length() >= 8 ) ? 8 : retVal.length();
        String datePart = retVal.substring( 0, dateMaxIndex ) + "0000".substring( 0, 8 - dateMaxIndex );

        String timePart = retVal.substring( dateMaxIndex, retVal.length() );

        if ( "000000".equals( timePart ) )
        {
            //19980116000000
            return retVal.substring( 0, 8 );
        }

        return retVal;
    }
}
