

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.template.generated.basedatatypes.HL72CodedElementLite;
import gov.va.med.cds.template.generated.vitalsigns.OxygenAdministration;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;


public abstract class SupplementalOxygenUserAbstractType
    implements
        CompositeUserType
{
    boolean isVWtype;


    public SupplementalOxygenUserAbstractType( boolean isVWtype )
    {
        this.isVWtype = isVWtype;
    }


    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SessionImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        String supplementalO2UomColumnValues = ( rs != null ) ? rs.getString( names[0] ) : null;
        if ( supplementalO2UomColumnValues == null )
        {
            return null;
        }

        SupplementalOxygen supplementalO2 = new SupplementalOxygen( supplementalO2UomColumnValues );
        OxygenAdministration ox02 = null;
       	
        	if ( supplementalO2.hasNameComponents() ){
        		ox02 = new OxygenAdministration();
        		String flowRateValue = supplementalO2.getFlowRateValue();
        		if ( flowRateValue != null && flowRateValue.length() > 0 ){
        			ox02.setFlowRateValue(flowRateValue);
        		
        			String flowRateUnitCode = supplementalO2.getFlowRateUnitCode();
        			String flowRateUnitDisplayText = supplementalO2.getFlowRateUnitDisplayText();
        			String flowRateUnitCodingSystem = supplementalO2.getFlowRateUnitCodingSystem();
        			int flowRateUnitCodeLength = ( flowRateUnitCode != null ) ? flowRateUnitCode.length() : 0;
        			int flowRateUnitDisplayTextLength = ( flowRateUnitDisplayText != null ) ? flowRateUnitDisplayText.length() : 0;
        			int flowRateUnitCodingSystemLength = ( flowRateUnitCodingSystem != null ) ? flowRateUnitCodingSystem.length() : 0;
        			HL72CodedElementLite flowRateUnit = new HL72CodedElementLite();
        			boolean addFRUnit=false;
        			if ( !isVWtype && flowRateUnitCodeLength > 0 )
        			{
        				flowRateUnit.setCode(supplementalO2.getFlowRateUnitCode());
        				addFRUnit=true;
        			}
        			if ( flowRateUnitDisplayTextLength > 0 )
        			{
        				flowRateUnit.setDisplayText(supplementalO2.getFlowRateUnitDisplayText());
        				addFRUnit=true;
        			}
        			if ( !isVWtype && flowRateUnitCodingSystemLength > 0 )
        			{
        				flowRateUnit.setCodingSystem(supplementalO2.getFlowRateUnitCodingSystem());
        				addFRUnit=true;
        			}
        			if(addFRUnit){
        				ox02.setFlowRateUnit(flowRateUnit);
        			}
        	
        		}
        		
        		String concentrationValue = supplementalO2.getConcentrationValue();
                if ( concentrationValue != null && concentrationValue.length() > 0 )
                {
                	ox02.setConcentrationValue(concentrationValue);
                	
                	String concentrationUnitCode = supplementalO2.getConcentrationUnitCode();
                    String concentrationUnitDisplayText = supplementalO2.getConcentrationUnitDisplayText();
                    String concentrationUnitCodingSystem = supplementalO2.getConcentrationUnitCodingSystem();
                    int concentrationUnitCodeLength = ( concentrationUnitCode != null ) ? concentrationUnitCode.length() : 0;
                    int concentrationUnitDisplayTextLength = ( concentrationUnitDisplayText != null ) ? concentrationUnitDisplayText.length() : 0;
                    int concentrationUnitCodingSystemLength = ( concentrationUnitCodingSystem != null ) ? concentrationUnitCodingSystem.length() : 0;
                    HL72CodedElementLite concentrationUnit = new HL72CodedElementLite();
                    boolean addCUnit=false;
                    if ( ( !isVWtype && ( concentrationUnitCodeLength > 0 || concentrationUnitCodingSystemLength > 0 ) )
                                    || concentrationUnitDisplayTextLength > 0 )
                    {
                        if ( !isVWtype && concentrationUnitCodeLength > 0 )
                        {
                        	concentrationUnit.setCode(supplementalO2.getConcentrationUnitCode());
                            addCUnit=true;
                        }
                        if ( concentrationUnitDisplayTextLength > 0 )
                        {
                        	concentrationUnit.setDisplayText(supplementalO2.getConcentrationUnitDisplayText());
                            addCUnit=true;
                        }
                        if ( !isVWtype && concentrationUnitCodingSystemLength > 0 )
                        {
                        	concentrationUnit.setCodingSystem(supplementalO2.getConcentrationUnitCodingSystem());
                            addCUnit=true;
                        }
                        if(addCUnit){
                        	ox02.setConcentrationUnit(concentrationUnit);
                        }
                    }
                }
        	}
        
        
       return ox02;
       
    }


    @Override
    public void nullSafeSet( PreparedStatement st, Object value, int index, SessionImplementor session )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( "SupplementalOxygenUserAbstractType nullSafeSet method not implemented." );
    }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object replace( Object original, Object target, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( "SupplementalOxygenUserAbstractType setPropertyValue method not implemented." );
    }


    @Override
    public Object assemble( Serializable cached, SessionImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SessionImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] {""};
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING };
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    @Override
    public Class returnedClass( )
    {
        return SupplementalOxygen.class;
    }
}
