/**
 * 
 */


package gov.va.med.cds.persistence.hibernate.common;


/**
 * A quantity specifying a point on the axis of natural time. A point in time is most often represented as a calendar
 * expression. Semantically, however, time is independent from calendars and best described by its relationship to
 * elapsed time (measured as a physical quantity in the dimension of time.) A point in time plus an elapsed time yields
 * another point in time. Inversely, a point in time minus another point in time yields an elapsed time. As nobody knows
 * when time began, a point in time is conceptualized as the amount of time that has elapsed from some arbitrary
 * zero-point, called an epoch. Because there is no absolute zero-point on the time axis natural time is a
 * difference-scale quantity, where only differences are defined but no ratios. (For example, no point in time is -
 * absolutely speaking - "twice as late" as another point in time.) Given some arbitrary zero-point, one can express any
 * point in time as an elapsed time measured from that offset. Such an arbitrary zero-point is called an epoch. This
 * epoch-offset form is used as a semantic representation here, without implying that any system would have to implement
 * the TS data type in that way. Systems that do not need to compute distances between points in time will not need any
 * other representation than a calendar expression literal
 * 
 * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public class PointInTime
{
    /**
     * For the default Gregorian calendar the calendar expression literals of this specification conform to the
     * constrained ISO 8601 that is defined in ISO 8824 (ASN.1) under clause 32 (generalized time) and to the HL7
     * version 2 TS data format.
     * 
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String timestamp;


    /**
     * @return the timestamp
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getTimestamp( )
    {
        // begin-user-code
        return timestamp;
        // end-user-code
    }


    /**
     * @param theTimestamp the timestamp to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setTimestamp( String theTimestamp )
    {
        // begin-user-code
        timestamp = theTimestamp;
        // end-user-code
    }
}
