/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author vhaislegberb
 * 
 * Class responsible for transforming PersonIdentifier instances into a form that can be used in a VistA read query.
 *
 */
public class VistaPersonIdentifierQueryParameterTransformer
    implements
        QueryParameterTransformerInterface
{

   /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transformAndSetParameter(java.lang.String, java.lang.Object, java.util.Map)
     */
    @Override
    public void transformAndSetParameter( String parameterName, Object parameterValue, Map<String, Object> parameterMap )
    {
        parameterMap.put( parameterName, transform(parameterValue) );
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.Object)
     */
    @Override
    public Object transform( Object parameterValue )
    {
        if( parameterValue instanceof List )
        {
            List<String> personIdentifiers = (List<String>)parameterValue;
            List<BigDecimal> bigDecimalPatientIdentifiers = new ArrayList<BigDecimal>();
    
            for ( String personId : personIdentifiers )
            {
                bigDecimalPatientIdentifiers.add( new BigDecimal( personId ) );
            }
            
            return bigDecimalPatientIdentifiers;
        }
        else 
        {
            throw new IllegalArgumentException("Parameter value for VistaPersonIdentifierQueryParameterTransformer must be of type list.");
        }
    }

    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.Object)
     */
    @Override
    public Object transform( String parameterValue )
    {
    	return new BigDecimal( parameterValue );
    }
}
