/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.template.generated.basedatatypes.PointInTime;


import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
 

public class PointInTimeQueryParameterTransformerPojo
    implements
        QueryParameterTransformerInterface
{
    
    protected static final String DATA_FORMAT_PATTERN = "yyyyMMddHHmmss";


    /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterSetterInterface#setParameter(java.lang.String, java.lang.Object, java.util.Map)
     */
    @Override
    public void transformAndSetParameter( String parameterName, Object parameterValue, Map<String, Object> parameterMap )
    {
        parameterMap.put( parameterName, transform(parameterValue) );
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.Object)
     */
    @Override
    public Object transform( Object parameterValue )
    {
        if( !(parameterValue instanceof Calendar))
        {
            throw new IllegalArgumentException("PointInTimeQueryParameterSetter only supports parameter values of type Calendar.");
        }
        
        Calendar date = (Calendar)parameterValue;
        PointInTime pointInTime = new PointInTime();
        //pointInTime.setTimestamp( new SimpleDateFormat( DATA_FORMAT_PATTERN ).format( date.getTime() ) );
        pointInTime.setLiteral(new SimpleDateFormat( DATA_FORMAT_PATTERN ).format( date.getTime() ) );
        
        return pointInTime;
    }
    
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryParameterTransformerInterface#transform(java.lang.String)
     */
    @Override  
    public Object transform( String parameterValue )
    {
    	return null;
    }
}
