/**
 * 
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.filter.EntryFilterInterface;

/**
 * @author vhaislegberb
 *
 */
public class OptionalParameterQueryNameBuilder
    implements
        QueryNameBuilderInterface
{

    /* (non-Javadoc)
     * @see gov.va.med.cds.persistence.hibernate.QueryNameBuilderInterface#buildQueryName(gov.va.med.cds.filter.EntryFilterInterface, java.lang.String)
     */
    @Override
    public String buildQueryName( EntryFilterInterface entryFilter, String associationName )
    {
        String queryName = String.format( "%s.%s.%s", entryFilter.getTemplateId(), entryFilter.getDomainEntryPoint(), associationName );

        if ( entryFilter.hasRecordIdentifiers() ) // query is by record identifier
        {
            queryName = String.format( "%s.identifiers", queryName );
        }
        else if ( entryFilter.useDates() ) // person ids and date query.
        {
            queryName = String.format( "%s.date", queryName );
        }
        
        return queryName;
    }

}
