

package gov.va.med.cds.persistence;


//import static gov.va.med.cds.exception.ErrorCodeEnum.VISTA_INSERT_OPERATION_FAILED;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.cds.rules.BooleanRuleInterface;


import java.util.List;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Element;


public class WriteableVistaPersistenceManager
    extends
        AbstractHibernatePersistenceManager
    implements
        WritePersistenceManagerInterface
{

    private List<BooleanRuleInterface> rules;
    private String cdsAppName;


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.WritePersistenceManagerInterface#isApplicable(java.lang.Object)
     */
    public boolean isApplicable( Object critera )
        throws PersistenceException
    {
        boolean b = false;
        for ( BooleanRuleInterface r : rules )
        {
            b = r.evaluate( critera );
            if ( b )
            {
                break;
            }
        }

        return b;
    }


    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.persistence.WritePersistenceManagerInterface#performCUADOnClinicalData(java.lang.String, gov.va.med.cds.clinicaldata.Operation, java.lang.Object)
     */
    @Override
    public String performCUADOnClinicalData( String templateId, Operation operation, Object aObject, DomainEntryPoint domainEntryPoint )
        throws PersistenceException
    {
        String resultId = "";

        try
        {

            if ( LOGGER.isDebugEnabled() )
            {
                LOGGER.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( templateId, null, cdsAppName, operation.name() + aObject ) );
            }
            
            aObject  = unmarshalElementToObject((Element)aObject, domainEntryPoint);
            
            if ( operation.equals( "Create" ) )
            {
                resultId = createData( aObject );
            }
            else
            {

                throw new UnsupportedOperationException( String.format( "The %s operation is not supported by the WriteableVistaPersistenceManager.",
                                operation.toString() ) );
            }

        }
        catch ( PersistenceException e )
        {
            throw e;
        }
        // any other problems are just big and will require someone to look at so check log file
        catch ( Exception e )
        {
            String rootCauseMessage = ExceptionUtils.getRootCause( e ) == null ? e.getMessage() : ExceptionUtils.getRootCause( e ).getMessage();
            //throw new PersistenceException( VISTA_INSERT_OPERATION_FAILED, e, operation.name(), rootCauseMessage, domainEntryPoint );

        }

        return resultId;
    }


    private String createData( Object aObject )
    {
        //TODO loop thru sessionMap to persist the object
        return null;
    }


    /**
     * Sets the rules to evaluate to determine if the persistence manager is applicable for the request.
     * 
     * @param rules The boolean rules to be evaluated.
     */
    public void setRules( List<BooleanRuleInterface> rules )
    {
        this.rules = rules;
    }


    public void setCdsAppName( String cdsAppName )
    {
        this.cdsAppName = cdsAppName;
    }


    @Override
    public String performCUADOnPatientsData( String templateId, String requestId, Operation requestType, Object object,
                    DomainEntryPoint domainEntryPoint )
        throws PersistenceException
    {
        // TODO Auto-generated method stub
        return null;
    }

} 