
package gov.va.med.cds.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.hibernate.VistaStoredProcedureWriteWork;
import gov.va.med.cds.response.strategy.VistaStoredProcedureResponseStrategyInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;

public class VistaStoredProcedureBasedWriteStrategy extends VistaStoredProcedureBasedQueryStrategy
{
	protected VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy;
	//protected Map<String, String> queryMap;
	protected Map<String, String> templateTimeoutMap;
	protected PooledConnectionUnwrapperInterface pooledConnectionUnwrapper;
	private Map<String, Set<String>> templateIdToDataListMap;

	public List<QueryWorkInterface> createQueryWork(SessionFactory factory, EntryFilterInterface entryFilter, 
			List<String> personIdentifiers, Class<?> pointInTimeUserType, String siteId,
			JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller)

	{
		List<QueryWorkInterface> queryWork = new ArrayList<QueryWorkInterface>();

		for (QueryAssociationInterface queryAssociation : templateAssociationMap.values()) {
			Session session = null;
			if (this.interceptorBeanName != null && this.interceptorBeanName.length() > 0) {
				session = factory.withOptions()
						.interceptor(this.beanFactory.getBean(interceptorBeanName, Interceptor.class)).openSession();
			} else {
				session = factory.openSession();
			}

			// create work for each of the query meta data(s) found in the query
			// plan map
			QueryWorkInterface work = createQueryWork(session, queryAssociation, entryFilter,
					personIdentifiers, pointInTimeUserType, siteId, marshallerUnmarshaller);
			queryWork.add(work);
		}

		return queryWork;
	}

	protected QueryWorkInterface createQueryWork(Session session, QueryAssociationInterface queryAssociation,
			EntryFilterInterface entryFilter, List<String> personIdentifiers,
			Class<?> pointInTimeUserType, String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {

		VistaStoredProcedureWriteWork queryWork = new VistaStoredProcedureWriteWork(session, queryAssociation,
				entryFilter, personIdentifiers, parameterTransformerMap, queryMap, vistaResponseStrategy,
				applicationName, siteId);
		queryWork.setTemplateTimeoutMap(templateTimeoutMap);
		queryWork.setVistaResponseStrategy(vistaResponseStrategy);
		queryWork.setQueryMap(queryMap);
		queryWork.setPooledConnectionUnwrapper(pooledConnectionUnwrapper);
		queryWork.setTemplateIdToDataListMap(templateIdToDataListMap);
		return queryWork;
	}
	public void setVistaResponseStrategy(VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy) {
		this.vistaResponseStrategy = vistaResponseStrategy;
	}

	public void setQueryMap(Map<String, String> queryMap) {
		this.queryMap = queryMap;
	}

	public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
		this.templateTimeoutMap = templateTimeoutMap;
	}

	public void setPooledConnectionUnwrapper(PooledConnectionUnwrapperInterface pooledConnectionUnwrapper) {
		this.pooledConnectionUnwrapper = pooledConnectionUnwrapper;
	}

	public void setTemplateIdToDataListMap(Map<String, Set<String>> templateIdToDataListMap) {
		this.templateIdToDataListMap = templateIdToDataListMap;
	}
}
