
package gov.va.med.cds.persistence;

import java.util.List;
import java.util.Map;

import org.hibernate.Session;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.hibernate.VistaStoredProcedureQueryWork;
import gov.va.med.cds.response.strategy.VistaStoredProcedureResponseStrategyInterface;
import gov.va.med.cds.template.generated.JaxBMarshallerUnmarshallerInterface;

public class VistaStoredProcedureBasedQueryStrategy extends DefaultAssociationBasedQueryStrategy
{
	protected VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy;
	protected Map<String, String> queryMap;
	protected Map<String, String> templateTimeoutMap;
	protected PooledConnectionUnwrapperInterface pooledConnectionUnwrapper;

	// TODO - would be nice to be able to rework because the
	// JaxBMarshallerUnmarshallerInterface will not be used for stored procedure
	// work, but it would require a lot of changes to the framework
	// so in order to compile stored procedure work will ignore the
	// marshallerUnmarshaller, it will go unused.
	protected QueryWorkInterface createQueryWork(Session session, QueryAssociationInterface queryAssociation,
			EntryFilterInterface entryFilter, List<String> personIdentifiers, Class<?> pointInTimeUserType,
			String siteId, JaxBMarshallerUnmarshallerInterface marshallerUnmarshaller) {

		VistaStoredProcedureQueryWork queryWork = new VistaStoredProcedureQueryWork(session, queryAssociation,
				entryFilter, personIdentifiers, parameterTransformerMap, queryMap, vistaResponseStrategy,
				applicationName, siteId);
		queryWork.setTemplateTimeoutMap(templateTimeoutMap);
		queryWork.setVistaResponseStrategy(vistaResponseStrategy);
		queryWork.setQueryMap(queryMap);
		queryWork.setPooledConnectionUnwrapper(pooledConnectionUnwrapper);
		return queryWork;
	}

 
	public void setVistaResponseStrategy(VistaStoredProcedureResponseStrategyInterface vistaResponseStrategy) {
		this.vistaResponseStrategy = vistaResponseStrategy;
	}

	public void setQueryMap(Map<String, String> queryMap) {
		this.queryMap = queryMap;
	}

	public void setTemplateTimeoutMap(Map<String, String> templateTimeoutMap) {
		this.templateTimeoutMap = templateTimeoutMap;
	}

	public void setPooledConnectionUnwrapper(PooledConnectionUnwrapperInterface pooledConnectionUnwrapper) {
		this.pooledConnectionUnwrapper = pooledConnectionUnwrapper;
	}
}
