

package gov.va.med.cds.persistence;


import gov.va.med.cds.exception.ErrorCodeEnum;

import org.apache.commons.lang3.exception.ExceptionUtils;


/**
 * Handles exceptions thrown by persistence processor.
 * 
 */
public class ReadException
    extends
        PersistenceException
{

    private static final long serialVersionUID = 4783429399489832692L;


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public ReadException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public ReadException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public ReadException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public ReadException( ErrorCodeEnum errorCodeName, Throwable cause )
    {
        super( errorCodeName, cause, (ExceptionUtils.getRootCause( cause )==null ? cause.getMessage(): ExceptionUtils.getRootCause( cause ).getMessage()) );
    }
}
