/**
 * 
 */
package gov.va.med.cds.filter;

import java.util.Set;

/**
 * @author susarlan
 *
 * The ParameterMap used to keep track of the query parameters specified in a filter.
 * 
 */
public interface ParameterMapInterface 
{
	/***
	 * Returns a Set view of the parameter names specified in the filter 
	 */
	public Set<String> getFilterParameterNames();

	/***
	 * Returns the QueryParameter to which the specified 'parameterName is mapped
	 * or null if this map contains no mapping for the 'parameterName'.
	 * 
	 * @param String parameterName - name of the query parameter
	 * 
	 * @return QueryParameter - QueryParameter object that maps to the specified parameterName or null
	 */
	public QueryParameter<?> getParameterValue(String parameterName); 
}
