

package gov.va.med.cds.filter;


import java.util.List;


/**
 * Provides the interface necessary through the Mbean implementation to allow access to the Filter Cache parameters from
 * the WebLogic console. This means that the administrator of the system can perform the methods specified here from a
 * WebLogic administrative web page.
 * 
 */
public interface FilterManagerMBeanInterface
{

    /**
     * Empty the Filter Memory Cache.
     */
    void clearFilterMemoryCache( );


    /**
     * Empty and reload the Filter Memory Cache from the database.
     */
    void reinitializeFilterMemoryCache( );


    /**
     * Resizes the Filter Memory Cache and reloads it from the database.
     */
    void resizeFilterMemoryCache( int newSize );


    /**
     * Gets the no. of schemas contained in Filter Memory Cache map.
     */
    int getNumberOfFilterSchemasLoadedIntoFilterCache( );


    /**
     * Gets the size of Filter Memory Cache threshold.
     */
    int getFilterCacheThreshold( );


    /**
     * gets available list of filterIds in filter cache
     * 
     * @return List of filterIds
     */
    List<String> getFilterCacheFilterIds( );
}
