/**
 * 
 */


package gov.va.med.cds.filter;


import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

import org.dom4j.Element;


/**
 * @author vhaislegberb
 *
 */
public class EntryFilterFactory
{
    private Map<String, Class<EntryFilterInterface>> filterIdToEntryFilterClassMap = new HashMap<String, Class<EntryFilterInterface>>();


    public EntryFilterInterface createEntryFilter( String filterId, String templateId, Element entryFilter, String requestId )
    {
        try
        {
            Class<EntryFilterInterface> _class = this.filterIdToEntryFilterClassMap.get( filterId );
            if ( _class != null )
            {
                Constructor<EntryFilterInterface> entryFilterConstructor = _class.getDeclaredConstructor( Element.class, String.class, String.class );
                return entryFilterConstructor.newInstance( entryFilter, templateId, requestId );
            }
        }
        catch ( Exception e )
        {
            throw new IllegalArgumentException( "Failed to instantiate entry filter interface.", e );
        }
        
        return new FilterQueryMetadata( entryFilter, templateId, requestId );
    }


    public void setFilterIdToEntryFilterClassMap( Map<String, Class<EntryFilterInterface>> filterIdToEntryFilterClassMap )
    {
        this.filterIdToEntryFilterClassMap = filterIdToEntryFilterClassMap;
    }
}
