

package gov.va.med.cds.client;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterfaceLocator;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;

import java.net.MalformedURLException;
import java.net.URL;


@RunWith( SuiteAwareRunner.class )
public class ClinicalDataServiceProxyTest
{

    ClinicalDataServiceSynchronousInterfaceLocator cdsServiceLocator = null;
    ClinicalDataServiceSynchronousInterface port = null;
    ClinicalDataServiceProxy serviceDelegate = null;


    @Test
    @Suite( groups = { "broken" } )
    public void testProxy( )
        throws MalformedURLException
    {

        URL url = new URL( "http://IP              /cds-wsclient/cds-service?wsdl" );

        cdsServiceLocator = new ClinicalDataServiceSynchronousInterfaceLocator( url );

        try
        {
            //cdsServiceLocator.setEndpointAddress( new javax.xml.namespace.QName( "http://client.cds.URL       ",
            //"ClinicalDataServiceSynchronousInterfaceHttpPort" ), "http://IP              /cds-wsclient/cds-service?wsdl" );
            port = cdsServiceLocator.getClinicalDataServiceSynchronousInterfaceHttpPort();
        }
        catch ( Exception e )
        {
            e.printStackTrace();
        }

        assertNotNull( port );
        serviceDelegate = new ClinicalDataServiceProxy();
        serviceDelegate.setProxy( port );
        assertNotNull( serviceDelegate );
    }

}
