/**
 * 
 */


package gov.va.med.cds.aspects.exception;


import gov.va.med.cds.exception.AbstractCdsBaseException;


/**
 * Re-throw exception that is invoked with 'afterThrowing' advice.
 *  
 * After a CDS exception is thrown from an advised call, log and re-throw the exception

 * @author susarlan
 *
 */
public class LogAndRethrowAspect
    extends
        LogAspect
{
    /**
     * Log the exception and re-throw.
     * Calls logException in order to log the exception
     * to a specified error logger or the default logger
     * 
     * @param cdsException - exception that was thrown during the handling of the request
     */
    public void doAfterThrowing( AbstractCdsBaseException cdsException )
    {
        logException( cdsException );
        throw cdsException;
    }
}
