

package gov.va.med.hdr.ars.client;


import gov.va.med.hdr.ars.client.webservice.ARServiceLocator;
import gov.va.med.hdr.ars.client.webservice.AggregateReportingServiceInterface;
import gov.va.med.hdr.ars.exception.ArsServiceException;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;


public class AggregateReportingServiceDelegate
    implements
        AggregateReportingServiceInterface
{
    private AggregateReportingServiceInterface arsSynchronous;
    private String arsWebserviceTimeoutSecs;
    private String arsServiceEndpoint;


    public AggregateReportingServiceDelegate( String arsWebserviceTimeoutSecs, String arsServiceEndpoint )
    {
        this.arsWebserviceTimeoutSecs = arsWebserviceTimeoutSecs;
        this.arsServiceEndpoint = arsServiceEndpoint;
        this.arsSynchronous = createArsWebServicePort();
    }


    public AggregateReportingServiceInterface createArsWebServicePort( )
    {
        try
        {
            ARServiceLocator service = new ARServiceLocator();
            service.setAggregateReportingServicePortEndpointAddress( arsServiceEndpoint );
            AggregateReportingServiceInterface port = service.getAggregateReportingServicePort();

            //            int timeoutSecs = Integer.parseInt( arsWebserviceTimeoutSecs );
            //
            //            if ( timeoutSecs > 0 )
            //            {
            //                Client client = ClientProxy.getClient( port );
            //                HTTPConduit http = ( HTTPConduit )client.getConduit();
            //
            //                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            //
            //                httpClientPolicy.setConnectionTimeout( timeoutSecs );
            //                httpClientPolicy.setAllowChunking( false );
            //                httpClientPolicy.setReceiveTimeout( timeoutSecs );
            //
            //                http.setClient( httpClientPolicy );
            //
            //            }

            return port;
        }
        catch ( Exception e )
        {
            throw new ArsServiceException( "ARS service business delegate Web service could not be obtained.", e );
        }
    }


    public void setArsSynchronous( AggregateReportingServiceInterface arsSynchronous )
    {
        this.arsSynchronous = arsSynchronous;
    }


    public boolean isAlive( )
    {
        boolean allNull = true;
        if ( arsSynchronous != null )
        {
            allNull = false;
            if ( !arsSynchronous.isAlive() )
                return false;
        }

        if ( allNull == true )
            throw new RuntimeException( "The sub delegate dependencies need to be injected. None were. Please check the configuration" );

        return true;
    }


    private void checkConfiguration( Object delegate )
        throws RuntimeException
    {
        if ( delegate == null )
        {
            throw new RuntimeException( "The ARS delegate " + " is missing and has not been injected - please check configuration." );
        }
    }


    @Override
    public String readAggregateData( String reportRequest, String reportId, String clientId, String requestId )
    {
        checkConfiguration( arsSynchronous );
        return arsSynchronous.readAggregateData( reportRequest, reportId, clientId, requestId );
    }

}
