

package gov.va.med.cds.ars.persistence;



import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


/**
 * @author stevebrush
 * 
 */
public interface ReadableReportsPersistenceManagerInterface
    extends
        PersistenceManagerInterface 
{

    
  /**
     * Handles the read requests.
     * 
     * @param aReportFilter - has info for reports, like date ranges and type of report.
     * @return a CDM object with a count and a list of records representing a single aggregate DAO.
     * @throws PersistenceException
     */
    HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException;

}
