package gov.va.med.cds.ars.persistence;


import java.util.ArrayList;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.HTHCumMonYearReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTHCumulativeMonYearReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTHCumulativeMonthYearReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class HthCumulativeMonYearReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    private String hthCumMonYearDataQuery = "CensusReports.hthCumulativemonthyearReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter)
        throws PersistenceException
	{
		HTHCumulativeMonthYearReportFilterType filter = aReportFilter.getHthCumulativeMonthYearReportFilter();
		HTHCumulativeMonYearReportDataType data = new HTHCumulativeMonYearReportDataType();
		Session session = this.sessionFactory.getCurrentSession();

		List<HTHCumMonYearReportDataType> results = null;

		try {
			results = getHthCumMonthYearData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setHthCumulativeMonYearReportData(data);

		return responseType;
	}


    @SuppressWarnings( "unchecked" )
    private List<HTHCumMonYearReportDataType> getHthCumMonthYearData( Session aSession, HTHCumulativeMonthYearReportFilterType hthReportFilter )
        throws PersistenceException
	{
		Query query = aSession.getNamedQuery(hthCumMonYearDataQuery);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthCumMonYearDataQuery + "  )*****");
		}

		List<HTHCumMonYearReportDataType> results = new ArrayList<HTHCumMonYearReportDataType>();

		try {
			results = (List<HTHCumMonYearReportDataType> )queryForReportData( query );
		} catch (Exception e) {
			LOGGER.error("Exception in getHthCumMonthYearData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthCumMonYearDataQuery);
		}

		return results;
	}

    public void setHthCumMonYearDataQuery(String hthCumMonYearDataQuery) {
		this.hthCumMonYearDataQuery = hthCumMonYearDataQuery;
	}
}

