package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusUnknownFacilityADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthUnknownFacilityADCDataQuery = "SurveyReports.UnknownfacilityAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusUnknownFacilityADCReportFilterType filter = aReportFilter.getCensusUnknownFacilityADCReportFilter();
		CensusUnknownFacilityADCReportDataType data = new CensusUnknownFacilityADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusUnknownFacilityADCLocationReportDataType> results = null;

		try {
			results = getUnknownFacilityADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusUnknownFacilityADCReportData(data);

		return responseType;
	}    


	@SuppressWarnings("unchecked")
	private List<CensusUnknownFacilityADCLocationReportDataType> getUnknownFacilityADCData( Session aSession, CensusUnknownFacilityADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthUnknownFacilityADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthUnknownFacilityADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusUnknownFacilityADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusUnknownFacilityADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getUnknownFacilityADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthUnknownFacilityADCDataQuery);
		}

		return results;
	}

    
    public void setHthUnknownFacilityADCDataQuery(String hthUnknownFacilityADCDataQuery) {
		this.hthUnknownFacilityADCDataQuery = hthUnknownFacilityADCDataQuery;
	}
}

