package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.VendorPatientCountDataType;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CensusTransformData {

	public static List <GeographicalAreaVendorPatientCountDataType> transformDataProcess ( List<CensusPatientCountDataType> dbResults){
		ArrayList <GeographicalAreaVendorPatientCountDataType> transformData = new ArrayList <GeographicalAreaVendorPatientCountDataType>();
		
		TreeMap <String, GeographicalAreaVendorPatientCountDataType.Vendors> treeMap = new TreeMap<String, GeographicalAreaVendorPatientCountDataType.Vendors>();
		
		int count;
		String number, name , location;
		GeographicalAreaVendorPatientCountDataType.Vendors vendors = null;
		VendorPatientCountDataType vendorPatientCount= null;
				
		for (CensusPatientCountDataType dbResult: dbResults)
		{
			location = dbResult.location;
			number = dbResult.number;
			name = dbResult.name;
			count = dbResult.count.intValue();
			
			if (!treeMap.containsKey(location)){
				vendors = new GeographicalAreaVendorPatientCountDataType.Vendors();
				treeMap.put(location, vendors);
			}
			else
			{
				vendors = treeMap.get(location);
			}
			vendorPatientCount = new VendorPatientCountDataType();
			vendorPatientCount.setCount(count);
			vendorPatientCount.setName(name);
			vendorPatientCount.setNumber(number);
			vendors.getVendor().add(vendorPatientCount);
		}
		
		GeographicalAreaVendorPatientCountDataType geoType ;
		
		for (Map.Entry<String, GeographicalAreaVendorPatientCountDataType.Vendors> entry : treeMap.entrySet()){
			String key = entry.getKey();
			vendors = entry.getValue();
			geoType = new GeographicalAreaVendorPatientCountDataType();
			geoType.setLocation(key);
			geoType.setVendors(vendors);
			transformData.add(geoType);
		}
		
		return transformData;
	}
	
}
