package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespGT30ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespGT30ReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalNonRespGT30RportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusRrTotalNonRespGT30RportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		RRTotalNonRespGT30ReportFilterType filter = aReportFilter.getRRTotalNonRespGT30ReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusRrTotalNonRespGT30RportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusRRTotalNonRespGT30RportQuery query procedure: " + censusRrTotalNonRespGT30RportQuery + " ======"  );
			        LOGGER.debug( " CensusRRTotalNonRespGT30Rport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusRRTotalNonRespGT30Rport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusRRTotalNonRespGT30Rport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusRRTotalNonRespGT30Rport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		RRTotalNonRespGT30ReportDataType data = new RRTotalNonRespGT30ReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setRRTotalNonRespGT30ReportData(data);
		
		return responseType;
		
	}

	public void setcensusRrTotalNonRespGT30RportQuery(
			String acensusRrTotalNonRespGT30RportQuery){
		this.censusRrTotalNonRespGT30RportQuery = acensusRrTotalNonRespGT30RportQuery;
	}

}
