package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalFullRespReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalFullRespReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalFullRespRportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusRrTotalFullRespRportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		RRTotalFullRespReportFilterType filter = aReportFilter.getRRTotalFullRespReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusRrTotalFullRespRportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusRRTotalFullRespRportQuery query procedure: " + censusRrTotalFullRespRportQuery + " ======"  );
			        LOGGER.debug( " CensusRRTotalFullRespRport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusRRTotalFullRespRport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusRRTotalFullRespRport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusRRTotalFullRespRport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		RRTotalFullRespReportDataType data = new RRTotalFullRespReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setRRTotalFullRespReportData(data);
		
		return responseType;
		
	}

	public void setcensusRrTotalFullRespRportQuery(
			String acensusRrTotalFullRespRportQuery){
		this.censusRrTotalFullRespRportQuery = acensusRrTotalFullRespRportQuery;
	}

}
