package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusPatientCountReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusPatientCountReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusPatientCountReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements CensusPatientCountReportPersistenceManagerInterface {
	
	protected String censusPatientCountReportQuery;
		

	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		CensusPatientCountReportFilterType filter = aReportFilter.getCensusPatientCountReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusPatientCountReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusPatientCountReport query procedure: " + censusPatientCountReportQuery + " ======"  );
			        LOGGER.debug( " CensusPatientCountReport  startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusPatientCountReport  endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusPatientCountReport  geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusPatientCountReport  vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
				
		CensusPatientCountReportDataType data = new CensusPatientCountReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCensusPatientCountReportData(data);
		
		return responseType;
		
	}

	public void setCensusPatientCountReportQuery(
			String aCensusPatientCountReportQuery){
		this.censusPatientCountReportQuery = aCensusPatientCountReportQuery;
	}

}
