package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusMeasurementPatientCountReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusMeasurementPatientCountReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusMeasurementCountReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements CensusMeasurementCountReportPersistenceManagerInterface {
	
	protected String censusMeasurementCountReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		CensusMeasurementPatientCountReportFilterType filter = aReportFilter.getCensusMeasurementPatientCountReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusMeasurementCountReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusPatientCountReport query procedure: " + censusMeasurementCountReportQuery + " ======"  );
			        LOGGER.debug( " CensusPatientCountReport  startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusPatientCountReport  endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusPatientCountReport  geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusPatientCountReport  vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		CensusMeasurementPatientCountReportDataType data = new CensusMeasurementPatientCountReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCensusMeasurementPatientCountReportData(data);
		
		return responseType;
		
	}

	public void setCensusMeasurementCountReportQuery(
			String aCensusMeasurementCountReportQuery){
		this.censusMeasurementCountReportQuery = aCensusMeasurementCountReportQuery;
	}

}
