

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.HtLevelOfCareReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HtLevelOfCareReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HtLevelsOfCareReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;


public class CensusLevelOfCareReportPersistenceManager extends AbstractReadableReportsPersistenceManager
	implements  ReadableReportsPersistenceManagerInterface  {
	
	protected String levelOfCareQuery = "SurveyReports.LevelOfCare";
	                                         
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
	   
        ObjectFactory objectFactory = new ObjectFactory();
        HtLevelsOfCareReportDataType data = objectFactory.createHtLevelsOfCareReportDataType();
        
        HtLevelsOfCareReportDataType.LevelsOfCare levelsOfCare = objectFactory.createHtLevelsOfCareReportDataTypeLevelsOfCare();
        data.setLevelsOfCare( levelsOfCare );
        HtLevelOfCareReportFilterType filter = aReportFilter.getHtHLevelOfCareReportFilter();

        Session session = this.sessionFactory.getCurrentSession();     
        
        try
        {
            
        	List<HtLevelOfCareReportDataType> results = null; 
            results = levelOfCareRepor( session, filter );
            data.getLevelsOfCare().getLevelOfCare().addAll( results );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setHtHLevelsOfCareReportData(data);
        
        return responseType;
        
    }
    

    @SuppressWarnings( "unchecked" )
    private List<HtLevelOfCareReportDataType> levelOfCareRepor( Session aSession, HtLevelOfCareReportFilterType aHtLevelOfCareReportFilterType  )
        throws PersistenceException
    {        
        Query query = aSession.getNamedQuery( levelOfCareQuery );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug("+++++ Calling Ht Level Of Care Repot stored proc: *****(  " + levelOfCareQuery+ "  )*****" );
        }
        
       List<HtLevelOfCareReportDataType> results = ( List<HtLevelOfCareReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with Census Ht Level Of Care Report stored proc" );
        }

        return results;
    }


    public void setLevelOfCareQuery( String aLevelOfCareQuery  )
    {
        this.levelOfCareQuery =  aLevelOfCareQuery ;
   
    }
}

