package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtNICReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtNICReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCocTotalPtNICReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusCocTotalPtNICReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		COCTotalPtNICReportFilterType filter = aReportFilter.getCoCTotalPtNICReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusCocTotalPtNICReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusCocTotalPtNICReport query procedure: " + censusCocTotalPtNICReportQuery + " ======"  );
			        LOGGER.debug( " CensusCocTotalPtNICReport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusCocTotalPtNICReport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusCocTotalPtNICReport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusCocTotalPtNICReport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		COCTotalPtNICReportDataType data = new COCTotalPtNICReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCoCTotalPtNICReportData(data);
		
		return responseType;
		
	}

	public void setcensusCocTotalPtNICReportQuery(
			String acensusCocTotalPtNICReportQuery){
		this.censusCocTotalPtNICReportQuery = acensusCocTotalPtNICReportQuery;
	}

}
