package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtCCMReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtCCMReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtCCMReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusCoCTotalPtCCMReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		COCTotalPtCCMReportFilterType filter = aReportFilter.getCoCTotalPtCCMReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusCoCTotalPtCCMReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusCoCTotalPtCCMReport query procedure: " + censusCoCTotalPtCCMReportQuery + " ======"  );
			        LOGGER.debug( " CensusCoCTotalPtCCMReport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusCoCTotalPtCCMReport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusCoCTotalPtCCMReport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusCoCTotalPtCCMReport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		COCTotalPtCCMReportDataType data = new COCTotalPtCCMReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCoCTotalPtCCMReportData(data);
		
		return responseType;
		
	}

	public void setcensusCoCTotalPtCCMReportQuery(
			String acensusCoCTotalPtCCMReportQuery){
		this.censusCoCTotalPtCCMReportQuery = acensusCoCTotalPtCCMReportQuery;
	}

}
