package gov.va.med.cds.ars.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder = {"numberOfVR12Records", "numberOfPatientSatisfactionRecords"})
public class NationalDistributionAggregateDAO 
	extends AggregateDAO
{
    private Integer numberOfVR12Records;
    private Integer numberOfPatientSatisfactionRecords;


    @XmlElement
    public Integer getNumberOfVR12Records( )
    {
        return numberOfVR12Records;
    }


    public void setNumberOfVR12Records( Integer numberOfVR12Records )
    {
        this.numberOfVR12Records = numberOfVR12Records;
    }

    @XmlElement
    public Integer getNumberOfPatientSatisfactionRecords( )
    {
        return numberOfPatientSatisfactionRecords;
    }


    public void setNumberOfPatientSatisfactionRecords( Integer numberOfPatientSatisfactionRecords )
    {
        this.numberOfPatientSatisfactionRecords = numberOfPatientSatisfactionRecords;
    }


    public String toString()
    {
        return "vr12 count: " + numberOfVR12Records + ",  PS count: " + numberOfPatientSatisfactionRecords + ", " + super.toString();
    }
}

