

package gov.va.med.cds.ars.filter;


import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.jaxb.JaxbHelper;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.exception.ErrorCodeEnum;

import javax.xml.bind.JAXBException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class FilterUnmarshaller 
	implements ReportFilterUnmarshallerInterface 
{
    protected static final String ARS_REPORT_SCHEMA_LOCATION = "classpath:resources/HTReportFilter.xsd";

	protected static final Log LOGGER = LogFactory.getLog( FilterUnmarshaller.class );
    private JaxbHelper jaxbHelper = null;
    

	public FilterUnmarshaller() 
	{
	}

	
	/* (non-Javadoc)
	 * @see gov.va.med.cds.ars.filter.FilterInterface#unMarshalReportFilter(java.lang.String)
	 */
	public HTReportFilterType unMarshalReportFilter(String aFilterInstance, String aReportId) 
	{
		HTReportFilterType htFilter = null;
		
		try
		{
		    htFilter = jaxbHelper.unmarshal( aFilterInstance, HTReportFilterType.class, ARS_REPORT_SCHEMA_LOCATION );
		} 
		catch (JAXBException e) 
		{
			String error = "Caught JAXBException: "+(e.getLinkedException() == null ? e.getMessage() : e.getLinkedException().getMessage());
			if ( LOGGER.isDebugEnabled() )
			{
			    LOGGER.debug( error );
			}
			//throw new ValidationException( ErrorCodeEnum.INVALID_FILTER_INSTANCE, e, aFilterInstance,  error );	  
			throw new ValidationException( ErrorCodeEnum.INVALID_FILTER_INSTANCE, e, "<![CDATA["+aFilterInstance+"]]>",  error );	   
		}
		catch( Exception e ) 
		{
			String error = "Caught Exception: "+e.getMessage();
            if ( LOGGER.isDebugEnabled() )
            {
                LOGGER.debug( error );
            }
            //throw new ValidationException( ErrorCodeEnum.INVALID_FILTER_INSTANCE, e, aFilterInstance,  error );	
            throw new ValidationException( ErrorCodeEnum.INVALID_FILTER_INSTANCE, e, "<![CDATA["+aFilterInstance+"]]>",  error );
		}
		
		return htFilter;
	}	
    
	
    public void setJaxbHelper( JaxbHelper aJaxbHelper )
    {
        this.jaxbHelper = aJaxbHelper;
    }
}