

package gov.va.med.cds.ars.exceptionframework;


import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * It's a Factory implementation for creating the concrete implementation of <code>ExceptionHandlerInterface</code>.
 * See gov.va.med.cds.config.exceptionHandlingConfigContext.xml for Spring DI details.
 * 
 */
public class ExceptionHandlerFactory
{
    private static ExceptionHandlerInterface exceptionHandler = null;
    private static ExceptionLoggerInterface guaranteedLogger = null;
    private static Log logger = LogFactory.getLog( ExceptionHandlerFactory.class );
    private static final String APPLICATION_NAME = "ARS";


    /**
     * Creates the default <code>IExceptionHandler</code> concrete implimentation based on the
     * <code>IExceptionHandlerFactory.EXCEPTION_HANDLER_KEY</code> parameter specified in <code>app.properties</code>.
     * 
     * @return IExceptionHandler instance based on parameter specified in <code>app.properties</code>
     */
    public ExceptionHandlerInterface create( )
    {
        if ( exceptionHandler == null )
        {
            if ( guaranteedLogger == null )
            {
                if ( logger.isWarnEnabled() )
                {
                    logger.warn( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME,
                                    "The guaranteed logger is null and must be set. Please check your configuration." ) );
                }
            }
            BaseExceptionHandler workingExceptionHandler = new BaseExceptionHandler();
            workingExceptionHandler.setGuaranteedLogger( guaranteedLogger );
            exceptionHandler = workingExceptionHandler;
        }
        
        return exceptionHandler;
    }


    public void setGuaranteedLogger( ExceptionLoggerInterface elogger )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "Setting the guaranteed logger: " + elogger ) );
        }
        guaranteedLogger = elogger;
    }

}
