

package gov.va.med.cds.ars;


import java.util.Date;

import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

import gov.va.med.cds.ars.audit.ReadAuditLogger;
import gov.va.med.cds.ars.request.RequestProcessorInterface;

import gov.va.med.cds.saml.SamlAssertionThreadLocal;

/**
 * ARS Service Implementation Bean (SIB)
 * 
 */

@Stateless( mappedName="ARService" )
@WebService( portName = "AggregateReportingServicePort", serviceName = "ARService", targetNamespace = "http://cds.URL       /", wsdlLocation = "wsdls/ARService.wsdl", endpointInterface = "gov.va.med.cds.ars.AggregateReportingServiceInterface" )
@BindingType( "http://schemas.xmlsoap.org/wsdl/soap/http" )
@HandlerChain(file = "handlers.xml")
@Interceptors(SpringBeanAutowiringInterceptor.class)
public class AggregateReportingService
    implements
    	AggregateReportingServiceInterface

{
	protected final Log logger = LogFactory.getLog(getClass());
	
	
	@Autowired
	private ReadAuditLogger auditLogger;
	@Autowired
    @Qualifier("requestProcessor")
    private RequestProcessorInterface reportProcessor = null;
    
    
    public AggregateReportingService( )
    {
        super();
    }


    public void init( )
    {
        logger.debug( "initializing the Patient Messaging Service." );
    }


    public boolean isAlive( )
    {
    	return true;
    }

    @WebMethod
	@Override
	public String readAggregateData(String reportRequest, String reportId, String clientId, String requestId) 
	{
	    if ( logger.isDebugEnabled() )
	    {
	        logger.debug( "++++++++++ Entered readAggregateData with reportRequest " + reportRequest );
	        logger.debug( "++++++++++ Entered readAggregateData with reportRequest: " + reportRequest );
	        logger.debug( "++++++++++ Entered readAggregateData with reportId: " + reportId );
	        logger.debug( "++++++++++ Entered readAggregateData with clientId: " + clientId );
	        logger.debug( "++++++++++ Entered readAggregateData with requestId: " + requestId );
	    }
		
		// Start time logging
        Long startTime = new Date().getTime();
        String readResult = reportProcessor.readAggregateData( reportRequest, reportId, clientId, requestId );
        auditLogger.recordAuditLog( startTime, readResult, reportRequest, reportId, clientId, requestId );
        
        return readResult;
	}

}
