/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.client;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.filter.FilterServiceInterface;
import gov.va.med.cds.template.TemplateServiceException;
import gov.va.med.cds.template.TemplateServiceInterface;
import gov.va.med.tfs.client.webservice.FilterMetaData;
import gov.va.med.tfs.client.webservice.TemplateFilterServiceInterface;
import gov.va.med.tfs.client.webservice.TemplateMetaData;
import gov.va.med.tfs.mapping.tfstocds.FilterMetaDataMapper;
import gov.va.med.tfs.mapping.tfstocds.TemplateMetaDataMapper;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WtfServiceManagement
implements TemplateServiceInterface,
FilterServiceInterface {
    private static Log logger = LogFactory.getLog(WtfServiceManagement.class);
    private TemplateFilterServiceInterface tfsService = null;

    public List<String> getActiveFilterIds(String aVhimVersion) {
        List<String> activeFilterIdsList = null;
        try {
            activeFilterIdsList = this.tfsService.getActiveFilterIds(aVhimVersion);
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement getActiveFilterIds Exception: " + e.getMessage()));
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, (Throwable)e, new String[]{aVhimVersion, e.getMessage()});
        }
        return activeFilterIdsList;
    }

    public List<String> getActiveTemplateIds(String aVhimVersion) {
        List<String> activeTemplateIdsList = null;
        try {
            activeTemplateIdsList = this.tfsService.getActiveTemplateIds(aVhimVersion);
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement getActiveTemplateIds Exception: " + e.getMessage()));
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, (Throwable)e, new String[]{aVhimVersion, e.getMessage()});
        }
        return activeTemplateIdsList;
    }

    public gov.va.med.cds.clinicaldata.FilterMetaData getFilterMetaData(String aFilterId) {
        gov.va.med.cds.clinicaldata.FilterMetaData cdsFilterMetaData = null;
        try {
            FilterMetaData tfsFilterMetaData = this.tfsService.getFilterMetaData(aFilterId);
            if (tfsFilterMetaData != null) {
                cdsFilterMetaData = FilterMetaDataMapper.getInstance().map(tfsFilterMetaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement getFilterMetaData Exception: " + e.getMessage()));
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, (Throwable)e, new String[]{aFilterId, e.getMessage()});
        }
        return cdsFilterMetaData;
    }

    public gov.va.med.cds.clinicaldata.TemplateMetaData getTemplateMetaData(String aTemplateId) {
        gov.va.med.cds.clinicaldata.TemplateMetaData cdsTemplateMetaData = null;
        try {
            TemplateMetaData tfsTemplateMetaData = this.tfsService.getTemplateMetaData(aTemplateId);
            if (tfsTemplateMetaData != null) {
                cdsTemplateMetaData = TemplateMetaDataMapper.getInstance().map(tfsTemplateMetaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement getTemplateMetaData Exception: " + e.getMessage()));
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, (Throwable)e, new String[]{aTemplateId, e.getMessage()});
        }
        return cdsTemplateMetaData;
    }

    public List<String> getVhimVersions() {
        List<String> vhimVersionsList = null;
        try {
            vhimVersionsList = this.tfsService.getVhimVersions();
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement getVhimVersions Exception: " + e.getMessage()));
            throw new TemplateServiceException(ErrorCodeEnum.CANNOT_LOAD_TEMPLATE_FROM_VTS, (Throwable)e, new String[]{"", e.getMessage()});
        }
        return vhimVersionsList;
    }

    public boolean isAlive() {
        try {
            return this.tfsService.isAlive();
        }
        catch (Exception e) {
            logger.error((Object)("WtfServiceManagement isAlive Exception: " + e.getMessage()));
            return false;
        }
    }

    public TemplateFilterServiceInterface getTfsService() {
        return this.tfsService;
    }

    public void setTfsService(TemplateFilterServiceInterface tfsService) {
        this.tfsService = tfsService;
    }

    public void initialize() {
        if (this.tfsService == null || !this.isAlive()) {
            logger.error((Object)"WtfServiceManagement isAlive() failed");
            throw new TemplateServiceException(ErrorCodeEnum.VTS_SERVICE_FAILED, null, new String[]{"isAlive() failed TFS Service is unavailable"});
        }
        logger.debug((Object)"WtfServiceManagement isAlive() is true");
    }
}

