/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.client;

import gov.va.med.cds.registry.JAXRUtility;
import gov.va.med.cds.util.EndpointResolver;
import gov.va.med.tfs.client.webservice.TemplateFilterServiceInterface;
import gov.va.med.tfs.client.webservice.WTFServiceLocator;
import gov.va.med.tfs.exception.WtfServiceCreateException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class TfsServiceFactory {
    private String serviceBindingId = null;
    private JAXRUtility jaxrHelper = null;
    private EndpointResolver endpointResolver = null;

    public synchronized TemplateFilterServiceInterface create(Integer tfsWebserviceTimeoutSecs) {
        try {
            return this.getBusinessDelegate(tfsWebserviceTimeoutSecs);
        }
        catch (Exception ex) {
            throw new WtfServiceCreateException("Could not create TAFS web service client.", ex);
        }
    }

    private TemplateFilterServiceInterface getBusinessDelegate(Integer tfsWebserviceTimeoutSecs) throws Exception {
        try {
            URL endpoint = new URL(this.endpointResolver.resolve(this.serviceBindingId));
            String endPointAsString = endpoint.toString();
            if (null != endPointAsString && !endPointAsString.contains("?")) {
                try {
                    endpoint = new URL(endPointAsString + "?wsdl");
                }
                catch (MalformedURLException e) {
                    throw new Exception(e);
                }
            }
            WTFServiceLocator wtfWsLocator = new WTFServiceLocator(endpoint);
            TemplateFilterServiceInterface port = wtfWsLocator.getTemplateFilterServicePort();
            if (tfsWebserviceTimeoutSecs != null) {
                Client client = ClientProxy.getClient((Object)port);
                HTTPConduit http = (HTTPConduit)client.getConduit();
                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
                httpClientPolicy.setConnectionTimeout((long)tfsWebserviceTimeoutSecs.intValue());
                httpClientPolicy.setAllowChunking(false);
                httpClientPolicy.setReceiveTimeout((long)tfsWebserviceTimeoutSecs.intValue());
                http.setClient(httpClientPolicy);
            }
            return port;
        }
        catch (Exception e) {
            throw new Exception("Error finding service in registry.", e);
        }
    }

    public void setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public void setServiceBindingId(String serviceBindingId) {
        this.serviceBindingId = serviceBindingId;
    }

    public void setJaxrHelper(JAXRUtility jaxrHelper) {
        this.jaxrHelper = jaxrHelper;
    }
}

