/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.tfdm;

import gov.va.med.tfs.tfdm.EntryFilter;
import gov.va.med.tfs.tfdm.FilterMetaDataInterface;
import gov.va.med.tfs.tfdm.VhimVersionWrapper;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class FilterMetaData
implements FilterMetaDataInterface,
Serializable {
    private String filterId;
    private String filterString;
    private Set<EntryFilter> entryFilters;
    private Set<String> vhimVersions;
    private Schema filterSchema;
    private String filterDescription;
    private boolean containsCorrelation;
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    private String filterSchemaXml;
    private Set<VhimVersionWrapper> vhimVersionWrappers = null;

    @Override
    public String getFilterId() {
        return this.filterId;
    }

    @Override
    public void setFilterId(String aFilterId) {
        this.filterId = aFilterId;
    }

    @Override
    public String getFilterString() {
        return this.filterString;
    }

    @Override
    public void setFilterString(String aFilterString) {
        this.filterString = aFilterString;
    }

    @Override
    public Set<String> getVhimVersions() {
        return this.vhimVersions;
    }

    @Override
    public void setVhimVersions(Set<String> aVhimVersions) {
        this.vhimVersions = aVhimVersions;
    }

    @Override
    public Set<VhimVersionWrapper> getVhimVersionWrappers() {
        if (this.vhimVersionWrappers == null && this.vhimVersions != null) {
            this.vhimVersionWrappers = new HashSet<VhimVersionWrapper>(this.vhimVersions.size());
            for (String vhimVersion : this.vhimVersions) {
                VhimVersionWrapper vvw = new VhimVersionWrapper();
                vvw.setVersion(vhimVersion);
                this.vhimVersionWrappers.add(vvw);
            }
        }
        return this.vhimVersionWrappers;
    }

    @Override
    public void setVhimVersionWrappers(Set<VhimVersionWrapper> aVhimVersionWrappers) {
        this.vhimVersionWrappers = aVhimVersionWrappers;
        if (this.vhimVersions == null && aVhimVersionWrappers != null) {
            this.vhimVersions = new HashSet<String>(aVhimVersionWrappers.size());
            for (VhimVersionWrapper vhimVersionWrapper : aVhimVersionWrappers) {
                this.vhimVersions.add(vhimVersionWrapper.getVersion());
            }
        }
    }

    @Override
    public Schema getFilterSchema() {
        return this.filterSchema;
    }

    @Override
    public void setFilterSchema(Schema aFilterSchema) {
        this.filterSchema = aFilterSchema;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date aDateAdded) {
        this.dateAdded = aDateAdded;
    }

    public Date getDateDeprecated() {
        return this.dateDeprecated;
    }

    public void setDateDeprecated(Date aDateDeprecated) {
        this.dateDeprecated = aDateDeprecated;
    }

    public Date getDateActivated() {
        return this.dateActivated;
    }

    public void setDateActivated(Date aDateActivated) {
        this.dateActivated = aDateActivated;
    }

    public Date getDateDeactivated() {
        return this.dateDeactivated;
    }

    public void setDateDeactivated(Date aDateDeactivated) {
        this.dateDeactivated = aDateDeactivated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date aDateUpdated) {
        this.dateUpdated = aDateUpdated;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String aStatus) {
        this.status = aStatus;
    }

    public void setFilterSchemaXml(String aFilterSchemaXml) {
        this.filterSchemaXml = aFilterSchemaXml;
    }

    public String getFilterSchemaXml() {
        return this.filterSchemaXml;
    }

    @Override
    public void setFilterSchema(String aFilterStringSchema) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.filterSchema = schemaFactory.newSchema(new StreamSource(new StringReader(aFilterStringSchema)));
        }
        catch (SAXException e) {
            throw new RuntimeException("Provided Filter schema is invalid : " + this.filterId, e);
        }
    }

    public void setFilterDescription(String aFilterDescription) {
        this.filterDescription = aFilterDescription;
    }

    public String getFilterDescription() {
        return this.filterDescription;
    }

    public void setContainsCorrelation(boolean aContainsCorrelation) {
        this.containsCorrelation = aContainsCorrelation;
    }

    public boolean isContainsCorrelation() {
        return this.containsCorrelation;
    }

    @Override
    public void setEntryFilters(Set<EntryFilter> aEntryFilters) {
        this.entryFilters = aEntryFilters;
    }

    @Override
    public Set<EntryFilter> getEntryFilters() {
        return this.entryFilters;
    }

    public String toString() {
        return "id: " + this.getFilterId() + ", desc: " + this.getFilterDescription() + ", dateAdded: " + this.dateAdded + ", status: " + this.status + ", vhims: " + this.getVhimVersions() + ", entryFilters: " + this.getEntryFilters() + "\nXML: " + this.getFilterSchemaXml();
    }
}

