/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs.persistence.hibernate;

import gov.va.med.tfs.persistence.ReadPersistenceManagerInterface;
import gov.va.med.tfs.persistence.hibernate.AbstractHibernatePersistenceManager;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class ReadableHibernatePersistenceManager
extends AbstractHibernatePersistenceManager
implements ReadPersistenceManagerInterface {
    protected TemplateMetaData readTemplateData(Session aSession, String aTemplateId) {
        TemplateMetaData queryResults = null;
        try {
            Query query = this.buildTemplateQuery(aSession, aTemplateId);
            queryResults = (TemplateMetaData)query.uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResults;
    }

    protected FilterMetaData readFilterData(Session aSession, String aFilterId) {
        FilterMetaData queryResults = null;
        try {
            Query query = this.buildFilterQuery(aSession, aFilterId);
            queryResults = (FilterMetaData)query.uniqueResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateMetaData readTemplateData(String aTemplateId) throws Exception {
        Session session = this.sessionFactory.openSession();
        TemplateMetaData hibernateQueryResult = null;
        try {
            hibernateQueryResult = this.readTemplateData(session, aTemplateId);
        }
        finally {
            session.clear();
        }
        return hibernateQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterMetaData readFilterData(String aFilterId) throws Exception {
        Session session = this.sessionFactory.openSession();
        FilterMetaData hibernateQueryResult = null;
        try {
            hibernateQueryResult = this.readFilterData(session, aFilterId);
        }
        finally {
            session.clear();
        }
        return hibernateQueryResult;
    }

    @Override
    public List<String> readActiveTemplateIds(String vhimVersion) {
        Session session = this.sessionFactory.openSession();
        Query query = session.getNamedQuery("TemplateSchemaIdsByStatus");
        query.setParameter("vhimVersion", (Object)vhimVersion);
        query.setParameter("status", (Object)"ACTIVE");
        List templates = query.list();
        return templates;
    }

    @Override
    public List<String> readActiveFilterIds(String vhimVersion) {
        Session session = this.sessionFactory.openSession();
        Query query = session.getNamedQuery("FilterSchemaIdsByStatus");
        query.setParameter("vhimVersion", (Object)vhimVersion);
        query.setParameter("status", (Object)"ACTIVE");
        List templates = query.list();
        return templates;
    }

    private Query buildTemplateQuery(Session aSession, String aTemplateId) throws Exception {
        String queryName = "TemplateSchemaIdByStatus";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("templateId", (Object)aTemplateId);
        query.setParameter("status", (Object)"ACTIVE");
        return query;
    }

    private Query buildFilterQuery(Session aSession, String aFilterId) throws Exception {
        String queryName = "FilterSchemaIdByStatus";
        Query query = aSession.getNamedQuery(queryName);
        query.setParameter("filterId", (Object)aFilterId);
        query.setParameter("status", (Object)"ACTIVE");
        return query;
    }

    @Override
    public String getManagerIdentifier() {
        return null;
    }

    @Override
    public List<String> readVhimVersions() {
        Session session = this.sessionFactory.openSession();
        Query query = session.getNamedQuery("AllVhimVersions");
        List vhimVersions = query.list();
        return vhimVersions;
    }
}

