/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.tfs;

import gov.va.med.tfs.TemplateFilterServiceInterface;
import gov.va.med.tfs.TemplateFilterServiceMBeanInterface;
import gov.va.med.tfs.persistence.CreateFilterPersistenceManagerInterface;
import gov.va.med.tfs.persistence.CreateTemplatePersistenceManagerInterface;
import gov.va.med.tfs.persistence.DeletePersistenceManagerInterface;
import gov.va.med.tfs.persistence.ReadPersistenceManagerInterface;
import gov.va.med.tfs.tfdm.FilterMetaData;
import gov.va.med.tfs.tfdm.TemplateMetaData;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ejb.interceptor.SpringBeanAutowiringInterceptor;

@Stateless(mappedName="WTFService")
@WebService(portName="TemplateFilterServicePort", serviceName="WTFService", targetNamespace="http://tfs.URL       /", wsdlLocation="wsdls/WTFService.wsdl", endpointInterface="gov.va.med.tfs.TemplateFilterServiceInterface")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
@Interceptors(value={SpringBeanAutowiringInterceptor.class})
public class TemplateFilterService
implements TemplateFilterServiceInterface,
TemplateFilterServiceMBeanInterface {
    private Log logger = LogFactory.getLog(TemplateFilterService.class);
    @Autowired
    @Qualifier(value="tfrReadable")
    private ReadPersistenceManagerInterface tfrReadable;
    @Autowired
    @Qualifier(value="tfrTemplateCreatable")
    private CreateTemplatePersistenceManagerInterface createTemplateManager;
    @Autowired
    @Qualifier(value="tfrFilterCreatable")
    private CreateFilterPersistenceManagerInterface createFilterManager;
    @Autowired
    @Qualifier(value="tfrDeletable")
    private DeletePersistenceManagerInterface deleteManager;
    private String SERVICE_EXCEPTION = "Service Exception Encountered: ";
    private String FUNCTION_DISABLED = "Requested Function is Not Enabled";
    private static boolean createEnabled;
    private static boolean deleteEnabled;

    public void init() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"initializing the template filter service.");
        }
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public List<String> getActiveTemplateIds(String vhimVersion) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered getActiveTemplateIds with vhimVersion " + vhimVersion));
        }
        List<String> activeTemplateIds = null;
        try {
            activeTemplateIds = this.tfrReadable.readActiveTemplateIds(vhimVersion);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ getActiveTemplateIds Exception: " + e.getStackTrace()));
            e.printStackTrace();
        }
        return activeTemplateIds;
    }

    @Override
    public List<String> getActiveFilterIds(String vhimVersion) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered getActiveFilterIds with vhimVersion " + vhimVersion));
        }
        List<String> activeFilterIds = null;
        try {
            activeFilterIds = this.tfrReadable.readActiveFilterIds(vhimVersion);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ getActiveFilterIds Exception: " + e.getStackTrace()));
            e.printStackTrace();
        }
        return activeFilterIds;
    }

    @Override
    public List<String> getVhimVersions() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"++++++++++ Entered getVhimVersions");
        }
        List<String> versions = null;
        try {
            versions = this.tfrReadable.readVhimVersions();
        }
        catch (Exception e) {
            System.out.println("++++++++++ getVhimVersions Exception: " + e.getMessage());
            this.logger.error((Object)("++++++++++ getVhimVersions Exception: " + e.getStackTrace()));
            e.printStackTrace();
        }
        return versions;
    }

    @Override
    public FilterMetaData getFilterMetaData(String aFilterId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered getFilterMetaData with FilterId " + aFilterId));
        }
        FilterMetaData filter = null;
        try {
            filter = this.tfrReadable.readFilterData(aFilterId);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ getFilterMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
        }
        return filter;
    }

    @Override
    public TemplateMetaData getTemplateMetaData(String aTemplateId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered getTemplateMetaData with TemplateId " + aTemplateId));
        }
        TemplateMetaData template = null;
        try {
            template = this.tfrReadable.readTemplateData(aTemplateId);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ getTemplateMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
        }
        return template;
    }

    @Override
    public String createFilterMetaData(FilterMetaData aFilterMetaData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered createFilterMetaData with FilterId " + aFilterMetaData.getFilterId()));
        }
        String returnPersist = null;
        if (!this.isCreateEnabled()) {
            return this.FUNCTION_DISABLED;
        }
        try {
            this.setFilterDerivedAttributes(aFilterMetaData);
            returnPersist = this.createFilterManager.createFilterData(aFilterMetaData);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ createFilterMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
            returnPersist = this.SERVICE_EXCEPTION + e.getMessage();
        }
        return returnPersist;
    }

    private void setFilterDerivedAttributes(FilterMetaData aFilterMetaData) {
        aFilterMetaData.setDateAdded(new Date());
    }

    @Override
    public String createTemplateMetaData(TemplateMetaData aTemplateMetaData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered createTemplateMetaData with TemplateId " + aTemplateMetaData.getTemplateId()));
        }
        String returnPersist = null;
        if (!this.isCreateEnabled()) {
            return this.FUNCTION_DISABLED;
        }
        try {
            this.setTemplateDerivedAttributes(aTemplateMetaData);
            returnPersist = this.createTemplateManager.createTemplateData(aTemplateMetaData);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ createTemplateMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
            returnPersist = this.SERVICE_EXCEPTION + e.getMessage();
        }
        return returnPersist;
    }

    private void setTemplateDerivedAttributes(TemplateMetaData aTemplateMetaData) {
        aTemplateMetaData.setDateAdded(new Date());
    }

    @Override
    public String deleteFilterMetaData(String aFilterId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered deleteFilterMetaData with FilterId " + aFilterId));
        }
        String returnDelete = null;
        if (!this.isDeleteEnabled()) {
            return this.FUNCTION_DISABLED;
        }
        try {
            returnDelete = this.deleteManager.deleteFilterData(aFilterId);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ deleteFilterMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
            returnDelete = this.SERVICE_EXCEPTION + e.getMessage();
        }
        return returnDelete;
    }

    @Override
    public String deleteTemplateMetaData(String aTemplateId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered deleteTemplateMetaData with TemplateId " + aTemplateId));
        }
        String returnDelete = null;
        if (!this.isDeleteEnabled()) {
            return this.FUNCTION_DISABLED;
        }
        try {
            returnDelete = this.deleteManager.deleteTemplateData(aTemplateId);
        }
        catch (Exception e) {
            this.logger.error((Object)("++++++++++ deleteTemplateMetaData Exception: " + e.getStackTrace()));
            e.printStackTrace();
            returnDelete = this.SERVICE_EXCEPTION + e.getMessage();
        }
        return returnDelete;
    }

    @Override
    public boolean isCreateEnabled() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered isCreateEnabled: " + createEnabled));
        }
        return createEnabled;
    }

    @Override
    public void setCreateEnabled(boolean createEnabledSwitch) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered setCreateEnabled: " + createEnabled));
        }
        createEnabled = createEnabledSwitch;
    }

    @Override
    public boolean isDeleteEnabled() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered isDeleteEnabled: " + deleteEnabled));
        }
        return deleteEnabled;
    }

    @Override
    public void setDeleteEnabled(boolean deleteEnabledSwitch) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("++++++++++ Entered setDeleteEnabled: " + deleteEnabled));
        }
        deleteEnabled = deleteEnabledSwitch;
    }
}

