/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.request;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.ars.filter.ReportFilterUnmarshallerInterface;
import gov.va.med.cds.ars.model.ModelMarshallerInterface;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.request.RequestProcessorInterface;
import gov.va.med.cds.ars.requestresponse.generated.ErrorSectionType;
import gov.va.med.cds.ars.requestresponse.generated.ErrorType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.ars.requestresponse.generated.ReportDateFilterType;
import gov.va.med.cds.ars.requestresponse.generated.ReportIDType;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportRequestProcessor
implements RequestProcessorInterface {
    public static final long CENSUS_EARLIEST_START_TIME = new GregorianCalendar(2005, 9, 2).getTimeInMillis();
    public static final long MILLIS_IN_ONE_DAY = 86400000L;
    protected static final Log LOGGER = LogFactory.getLog(ReportRequestProcessor.class);
    private ReportFilterUnmarshallerInterface filterUnmarshaller;
    private ModelMarshallerInterface modelMarshaller;
    private Map<String, ReadableReportsPersistenceManagerInterface> persistenceManagerMap;
    private ExceptionHandlerInterface exceptionHandler;
    private static final String APPLICATION_NAME = "ARS";

    @Override
    public String readAggregateData(String aReportRequestFilterXml, String aReportId, String aClientId, String aRequestId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("ARS readAggregateData:" + aReportRequestFilterXml));
        }
        ObjectFactory reportFactory = new ObjectFactory();
        HTReportType htReport = reportFactory.createHTReportType();
        HTResponseType reportResponse = null;
        ReportIDType reportType = null;
        try {
            ReadableReportsPersistenceManagerInterface persistenceManager;
            HTReportFilterType reportRequestFilter = null;
            this.requireInputParameters(aReportRequestFilterXml, aReportId, aClientId, aRequestId);
            reportRequestFilter = this.filterUnmarshaller.unMarshalReportFilter(aReportRequestFilterXml, aReportId);
            try {
                reportType = ReportIDType.fromValue(aReportId);
            }
            catch (IllegalArgumentException e) {
                throw new ValidationException(ErrorCodeEnum.ARS_READ_REQUEST_REPORT_ID_NULL);
            }
            htReport.setRequest(reportRequestFilter);
            if (reportRequestFilter == null) {
                throw new RuntimeException("Invalid Report Filter (unmarshalling failed) ");
            }
            ReportDateFilterType dateFilter = null;
            switch (reportType) {
                case VR_12_STATISTICS: {
                    dateFilter = reportRequestFilter.getVR12ReportFilter();
                    break;
                }
                case DISTRIBUTION_OF_SURVEYS: {
                    dateFilter = reportRequestFilter.getDistributionReportFilter();
                    break;
                }
                case PATIENT_SATISFACTION_STATISTICS: {
                    dateFilter = reportRequestFilter.getPatientSatisfactionReportFilter();
                    break;
                }
                case SURVEY_TRENDS: {
                    dateFilter = reportRequestFilter.getSurveyTrendReportFilter();
                    break;
                }
                case DMP_UNIQUE_ICN_REPORT: {
                    dateFilter = reportRequestFilter.getDMPUniqueICNReportFilter();
                    break;
                }
                case CENSUS_WEEKLY_VENDOR_STATUS_REPORT: {
                    dateFilter = reportRequestFilter.getCensusWeeklyVendorReportStatusFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_POST_PROCESSING_STATUS_REPORT: {
                    dateFilter = reportRequestFilter.getCensusPostProcessingStatusReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_TOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_DMPTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusDMPPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_MEDDEVTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusMedicalDevicePatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_IVRTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusIVRPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_BROWSERTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusBrowserPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_NOTASSIGNEDTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusNotAssignedPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_MEASUREMENTTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusMeasurementPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_VIDEOTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusVideoPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_CELLMODEMTOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusCellPatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case CENSUS_SATELLITETOTAL_REPORT: {
                    dateFilter = reportRequestFilter.getCensusSatellitePatientCountReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case COC_TOTALPTNIC_REPORT: {
                    dateFilter = reportRequestFilter.getCoCTotalPtNICReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case COC_TOTALPTCCM_REPORT: {
                    dateFilter = reportRequestFilter.getCoCTotalPtCCMReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case COC_TOTALPTACM_REPORT: {
                    dateFilter = reportRequestFilter.getCoCTotalPtACMReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case COC_TOTALPTHPDP_REPORT: {
                    dateFilter = reportRequestFilter.getCoCTotalPtHPDPReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case COC_TOTALPTL_2_REPORT: {
                    dateFilter = reportRequestFilter.getCoCTotalPtL2ReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALFULLRESP_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalFullRespReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALPARTRESP_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalPartRespReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALNONRESP_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalNonRespReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALUNKRESP_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalUnkRespReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALNONRESPGT_30_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalNonRespGT30ReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                    break;
                }
                case RR_TOTALNONRESPMAX_REPORT: {
                    dateFilter = reportRequestFilter.getRRTotalNonRespMaxReportFilter();
                    this.validateStartDateAndEndDate(dateFilter);
                }
            }
            if (dateFilter != null) {
                this.checkForRequiredDates(dateFilter);
            }
            if ((persistenceManager = this.persistenceManagerMap.get(aReportId)) == null) {
                throw new RuntimeException("No persistence manager found for report: " + aReportId);
            }
            reportResponse = persistenceManager.performReadReportAggregate(reportRequestFilter);
        }
        catch (RuntimeException e) {
            try {
                this.exceptionHandler.handleException(e, aReportId, aRequestId, aClientId + aRequestId, APPLICATION_NAME);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        htReport.setErrorSection(this.populateErrorSection(aRequestId, aClientId));
        htReport.setRequestID(aRequestId);
        htReport.setResponse(reportResponse);
        return this.modelMarshaller.marshalToXml(htReport);
    }

    private void checkForRequiredDates(ReportDateFilterType reportRequestFilter) {
        if (reportRequestFilter.getStartDate() == null || reportRequestFilter.getEndDate() == null) {
            throw new RuntimeException("Start and End Dates are required for this report type: " + reportRequestFilter.getReportID().value());
        }
    }

    private ErrorSectionType populateErrorSection(String aRequestId, String aClientId) {
        ErrorSectionType errorSection = new ErrorSectionType();
        LoggingSeverity loggingSeverity = null;
        ErrorType errorType = null;
        block4: for (ExceptionInfo exceptionInfo : this.exceptionHandler.getExceptionInfoList(aClientId + aRequestId)) {
            errorType = new ErrorType();
            errorType.setDisplayMessage(exceptionInfo.getClientMessage());
            Throwable t = exceptionInfo.getException();
            if (t != null) {
                errorType.setException(exceptionInfo.getException().getClass().getName());
            }
            errorType.setExceptionMessage(exceptionInfo.getExceptionMessage());
            if (exceptionInfo.getErrorCode() != null) {
                errorType.setErrorCode(exceptionInfo.getErrorCode().name());
            }
            errorType.setErrorId(aRequestId);
            loggingSeverity = exceptionInfo.getLoggingSeverity();
            if (loggingSeverity == null) {
                loggingSeverity = LoggingSeverity.FATAL;
                exceptionInfo.setLoggingSeverity(LoggingSeverity.FATAL);
            }
            switch (loggingSeverity) {
                case WARNING: {
                    errorSection.getWarnings().add(errorType);
                    continue block4;
                }
                case ERROR: {
                    errorSection.getErrors().add(errorType);
                    continue block4;
                }
            }
            errorSection.getFatalErrors().add(errorType);
        }
        this.exceptionHandler.clear(aClientId + aRequestId);
        return errorSection;
    }

    private void requireInputParameters(String aReportRequestFilterXml, String aReportId, String aClientId, String aRequestId) {
        if (aReportRequestFilterXml == null || aReportRequestFilterXml.length() == 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_FILTER_XML_NULL);
        }
        if (aRequestId == null || aRequestId.length() == 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_REQUEST_ID_NULL);
        }
        if (aClientId == null || aClientId.length() == 0) {
            throw new ValidationException(ErrorCodeEnum.READ_REQUEST_CLIENT_ID_NULL);
        }
        if (aReportId == null || aReportId.length() == 0) {
            throw new ValidationException(ErrorCodeEnum.ARS_READ_REQUEST_REPORT_ID_NULL);
        }
    }

    public void setExceptionHandler(ExceptionHandlerInterface exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setFilterUnmarshaller(ReportFilterUnmarshallerInterface filterUnmarshaller) {
        this.filterUnmarshaller = filterUnmarshaller;
    }

    public void setModelMarshaller(ModelMarshallerInterface modelMarshaller) {
        this.modelMarshaller = modelMarshaller;
    }

    public void setPersistenceManagerMap(Map<String, ReadableReportsPersistenceManagerInterface> persistenceManagerMap) {
        this.persistenceManagerMap = persistenceManagerMap;
    }

    protected void validateStartDateAndEndDate(ReportDateFilterType dateFilter) throws ValidationException {
        XMLGregorianCalendar xmlStartDate = dateFilter.getStartDate();
        XMLGregorianCalendar xmlEndDate = dateFilter.getEndDate();
        GregorianCalendar startDate = dateFilter.getStartDate().toGregorianCalendar();
        GregorianCalendar currentDate = new GregorianCalendar();
        long currentTime = currentDate.getTimeInMillis() - 86400000L;
        long startTime = startDate.getTimeInMillis();
        if (1 != startDate.get(7) || startTime < CENSUS_EARLIEST_START_TIME || startTime > currentTime) {
            throw new ValidationException(ErrorCodeEnum.CENSUS_REPORT_INVALID_START_DATE, xmlStartDate.toString());
        }
        GregorianCalendar endDate = xmlEndDate.toGregorianCalendar();
        long endTime = endDate.getTimeInMillis();
        if (7 != endDate.get(7) || endTime > currentTime) {
            throw new ValidationException(ErrorCodeEnum.CENSUS_REPORT_INVALID_END_DATE, xmlEndDate.toString());
        }
        if (6 != (int)Math.round((double)(endTime - startTime) / 8.64E7)) {
            throw new ValidationException(ErrorCodeEnum.CENSUS_REPORT_INVALID_TIME_PERIOD, xmlEndDate.toString(), xmlStartDate.toString());
        }
    }
}

