/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.VR12LocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class VR12ReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String vr12DataQuery = "SurveyReports.vr12.data";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        VR12ReportFilterType filter = aReportFilter.getVR12ReportFilter();
        VR12ReportDataType data = new VR12ReportDataType();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<VR12LocationReportDataType> results = null;
            Integer surveyCount = null;
            results = this.vr12ReadReportAggregate(session, filter);
            surveyCount = this.getSurveyCount(results);
            data.getReportData().addAll(results);
            data.setNumberOfRecordsConsidered(surveyCount);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setVR12ReportData(data);
        return this.responseType;
    }

    private List<VR12LocationReportDataType> vr12ReadReportAggregate(Session aSession, VR12ReportFilterType aVR12ReportFilter) throws PersistenceException {
        String location = aVR12ReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(aVR12ReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aVR12ReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.vr12DataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling VR12 stored proc: *****(  " + this.vr12DataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with VR12 stored proc");
        }
        return results;
    }

    public void setVr12DataQuery(String aVr12DataQuery) {
        this.vr12DataQuery = aVr12DataQuery;
    }
}

