/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class TrendsReportsPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String trendsQuery = "SurveyReports.trends";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        TrendReportFilterType filter = aReportFilter.getSurveyTrendReportFilter();
        TrendReportDataType data = new TrendReportDataType();
        try (Session session = this.sessionFactory.getCurrentSession();){
            List<LocationReportDataType> results = null;
            Integer surveyCount = null;
            results = this.trendsReport(session, filter);
            surveyCount = this.getSurveyCount(results);
            data.getReportData().addAll(results);
            data.setNumberOfRecordsConsidered(surveyCount);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setSurveyTrendReportData(data);
        return this.responseType;
    }

    private List<LocationReportDataType> trendsReport(Session aSession, TrendReportFilterType aTrendReportFilter) throws PersistenceException {
        String surveyVersion = aTrendReportFilter.getSurveyVersion();
        String surveyType = aTrendReportFilter.getSurveyType() == null ? null : aTrendReportFilter.getSurveyType().value();
        String location = aTrendReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(aTrendReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(aTrendReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.trendsQuery);
        query.setString("surveyVersion", surveyVersion);
        query.setString("surveyType", surveyType);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling Trends stored proc: *****(  " + this.trendsQuery + "  )*****"));
            LOGGER.debug((Object)(" surveyVersion: " + surveyVersion));
            LOGGER.debug((Object)(" surveyType: " + surveyType));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = this.queryForReportData(query);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"----- Done with Trends stored proc");
        }
        return results;
    }

    public void setTrendsQuery(String aTrendsQuery) {
        this.trendsQuery = aTrendsQuery;
    }
}

