/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusWeeklyVendorStatusReportPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusWeeklyVendorStatusReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusWeeklyVendorStatusReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusWeeklyVendorStatusReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements CensusWeeklyVendorStatusReportPersistenceManagerInterface {
    protected String censusWeeklyVendorStatusReportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        CensusWeeklyVendorStatusReportFilterType filter = aReportFilter.getCensusWeeklyVendorReportStatusFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusWeeklyVendorStatusReportQuery);
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusWeeklyVendorStatusReport query procedure: " + this.censusWeeklyVendorStatusReportQuery + " ======"));
                LOGGER.debug((Object)(" CensusWeeklyVendorStatusReport startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusWeeklyVendorStatusReport   endDate: '" + sqlEndDate + "'"));
            }
            results = this.queryForReportData(query);
        }
        CensusWeeklyVendorStatusReportDataType data = new CensusWeeklyVendorStatusReportDataType();
        CensusWeeklyVendorStatusReportDataType.Vendors vendors = new CensusWeeklyVendorStatusReportDataType.Vendors();
        vendors.getVendor().addAll(results);
        data.setVendors(vendors);
        data.setReportID(filter.getReportID());
        this.responseType.setCensusWeeklyVendorStatusReportData(data);
        return this.responseType;
    }

    public void setCensusWeeklyVendorStatusReportQuery(String censusWeeklyVendorStatusReport) {
        this.censusWeeklyVendorStatusReportQuery = censusWeeklyVendorStatusReport;
    }
}

