/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusUrbanVISNADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthUrbanVISNADCDataQuery = "SurveyReports.UrbanvisnAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusUrbanVISNADCReportFilterType filter = aReportFilter.getCensusUrbanVISNADCReportFilter();
        CensusUrbanVISNADCReportDataType data = new CensusUrbanVISNADCReportDataType();
        List<CensusUrbanVISNADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getUrbanVISNADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusUrbanVISNADCReportData(data);
        return this.responseType;
    }

    private List<CensusUrbanVISNADCLocationReportDataType> getUrbanVISNADCData(Session aSession, CensusUrbanVISNADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthUrbanVISNADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthUrbanVISNADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getUrbanVISNADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthUrbanVISNADCDataQuery));
        }
        return results;
    }

    public void setHthUrbanVISNADCDataQuery(String hthUrbanVISNADCDataQuery) {
        this.hthUrbanVISNADCDataQuery = hthUrbanVISNADCDataQuery;
    }
}

