/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusUrbanFacilityADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthUrbanFacilityADCDataQuery = "SurveyReports.UrbanFacilityADCReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusUrbanFacilityADCReportFilterType filter = aReportFilter.getCensusUrbanFacilityADCReportFilter();
        CensusUrbanFacilityADCReportDataType data = new CensusUrbanFacilityADCReportDataType();
        List<CensusUrbanFacilityADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getUrbanFacilityADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusUrbanFacilityADCReportData(data);
        return this.responseType;
    }

    private List<CensusUrbanFacilityADCLocationReportDataType> getUrbanFacilityADCData(Session aSession, CensusUrbanFacilityADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthUrbanFacilityADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthUrbanFacilityADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getUrbanFacilityADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthUrbanFacilityADCDataQuery));
        }
        return results;
    }

    public void setHthUrbanFacilityADCDataQuery(String hthUrbanFacilityADCDataQuery) {
        this.hthUrbanFacilityADCDataQuery = hthUrbanFacilityADCDataQuery;
    }
}

