/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusUnknownVISNADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthUnknownVISNADCDataQuery = "SurveyReports.UnknownvisnAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusUnknownVISNADCReportFilterType filter = aReportFilter.getCensusUnknownVISNADCReportFilter();
        CensusUnknownVISNADCReportDataType data = new CensusUnknownVISNADCReportDataType();
        List<CensusUnknownVISNADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getUnknownVISNADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusUnknownVISNADCReportData(data);
        return this.responseType;
    }

    private List<CensusUnknownVISNADCLocationReportDataType> getUnknownVISNADCData(Session aSession, CensusUnknownVISNADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthUnknownVISNADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthUnknownVISNADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getUnknownVISNADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthUnknownVISNADCDataQuery));
        }
        return results;
    }

    public void setHthUnknownVISNADCDataQuery(String hthUnknownVISNADCDataQuery) {
        this.hthUnknownVISNADCDataQuery = hthUnknownVISNADCDataQuery;
    }
}

