/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusTotalRuralVISNADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthVISNADCDataQuery = "SurveyReports.TotalRuralvisnAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusTotalRuralVISNADCReportFilterType filter = aReportFilter.getCensusTotalRuralVISNADCReportFilter();
        CensusTotalRuralVISNADCReportDataType data = new CensusTotalRuralVISNADCReportDataType();
        List<CensusTotalRuralVISNADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getTotalRuralVISNADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusTotalRuralVISNADCReportData(data);
        return this.responseType;
    }

    private List<CensusTotalRuralVISNADCLocationReportDataType> getTotalRuralVISNADCData(Session aSession, CensusTotalRuralVISNADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthVISNADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthVISNADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getTotalRuralVISNADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc" + this.hthVISNADCDataQuery));
        }
        return results;
    }

    public void setHthVISNADCDataQuery(String hthVISNADCDataQuery) {
        this.hthVISNADCDataQuery = hthVISNADCDataQuery;
    }
}

