/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusTotalRuralFacilityADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthTotalRuralFacilityADCDataQuery = "SurveyReports.TotalRuralfacilityAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusTotalRuralFacilityADCReportFilterType filter = aReportFilter.getCensusTotalRuralFacilityADCReportFilter();
        CensusTotalRuralFacilityADCReportDataType data = new CensusTotalRuralFacilityADCReportDataType();
        List<CensusTotalRuralFacilityADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getTotalRuralFacilityADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusTotalRuralFacilityADCReportData(data);
        return this.responseType;
    }

    private List<CensusTotalRuralFacilityADCLocationReportDataType> getTotalRuralFacilityADCData(Session aSession, CensusTotalRuralFacilityADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthTotalRuralFacilityADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthTotalRuralFacilityADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getTotalRuralFacilityADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthTotalRuralFacilityADCDataQuery));
        }
        return results;
    }

    public void setHthTotalRuralFacilityADCDataQuery(String hthTotalRuralFacilityADCDataQuery) {
        this.hthTotalRuralFacilityADCDataQuery = hthTotalRuralFacilityADCDataQuery;
    }
}

