/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusTransformData;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespGT30ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespGT30ReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusRrTotalNonRespGT30RportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String censusRrTotalNonRespGT30RportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        RRTotalNonRespGT30ReportFilterType filter = aReportFilter.getRRTotalNonRespGT30ReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusRrTotalNonRespGT30RportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusRRTotalNonRespGT30RportQuery query procedure: " + this.censusRrTotalNonRespGT30RportQuery + " ======"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespGT30Rport   startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespGT30Rport   endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespGT30Rport   geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusRRTotalNonRespGT30Rport   vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientCountDataType> listData = null;
        listData = CensusTransformData.transformDataProcess(results);
        RRTotalNonRespGT30ReportDataType data = new RRTotalNonRespGT30ReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setRRTotalNonRespGT30ReportData(data);
        return this.responseType;
    }

    public void setcensusRrTotalNonRespGT30RportQuery(String acensusRrTotalNonRespGT30RportQuery) {
        this.censusRrTotalNonRespGT30RportQuery = acensusRrTotalNonRespGT30RportQuery;
    }
}

