/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusPostProcessingStatusReportPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusPostProcessingStatusReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.CensusPostProcessingStatusReportIDType;
import gov.va.med.cds.ars.requestresponse.generated.CensusPostProcessingStatusReportType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusPostProcessingStatusReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements CensusPostProcessingStatusReportPersistenceManagerInterface {
    protected String censusPostProcessingStatusReportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusPostProcessingStatusReportFilterType filter = aReportFilter.getCensusPostProcessingStatusReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusPostProcessingStatusReportQuery);
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusWeeklyVendorStatusReport query procedure: " + this.censusPostProcessingStatusReportQuery + " ======"));
                LOGGER.debug((Object)(" CensusWeeklyVendorStatusReport startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusWeeklyVendorStatusReport   endDate: '" + sqlEndDate + "'"));
            }
            results = this.queryForReportData(query);
        }
        if (results.size() != 1) {
            throw new PersistenceException(ErrorCodeEnum.CENSUS_REPORT_RECORD_COUNT_INVALID, new String[]{String.valueOf(results.size())});
        }
        CensusPostProcessingStatusReportType data = (CensusPostProcessingStatusReportType)results.get(0);
        data.setReportID(CensusPostProcessingStatusReportIDType.CENSUS_POST_PROCESSING_STATUS_REPORT);
        this.responseType.setCensusPostProcessingStatusReportData(data);
        return this.responseType;
    }

    public void setCensusPostProcessingStatusReportQuery(String censusPostProcessingStatusReportQuery) {
        this.censusPostProcessingStatusReportQuery = censusPostProcessingStatusReportQuery;
    }
}

