/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusHighlyRuralFacilityADCReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String hthHighlyRuralFacilityADCDataQuery = "SurveyReports.HighlyruralfacilityAdcReport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException {
        CensusHighlyRuralFacilityADCReportFilterType filter = aReportFilter.getCensusHighlyRuralFacilityADCReportFilter();
        CensusHighlyRuralFacilityADCReportDataType data = new CensusHighlyRuralFacilityADCReportDataType();
        List<CensusHighlyRuralFacilityADCLocationReportDataType> results = null;
        try (Session session = this.sessionFactory.getCurrentSession();){
            results = this.getHighlyRuralFacilityADCData(session, filter);
            data.getReportData().addAll(results);
            data.setReportID(filter.getReportID());
        }
        this.responseType.setCensusHighlyRuralFacilityADCReportData(data);
        return this.responseType;
    }

    private List<CensusHighlyRuralFacilityADCLocationReportDataType> getHighlyRuralFacilityADCData(Session aSession, CensusHighlyRuralFacilityADCReportFilterType censusReportFilter) throws PersistenceException {
        String location = censusReportFilter.getGeographicalArea().getLocation();
        java.sql.Date startDate = this.formatDate(censusReportFilter.getStartDate());
        java.sql.Date endDate = this.formatDate(censusReportFilter.getEndDate());
        Query query = aSession.getNamedQuery(this.hthHighlyRuralFacilityADCDataQuery);
        query.setString("location", location);
        query.setDate("startDate", (Date)startDate);
        query.setDate("endDate", (Date)endDate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("+++++ Calling stored proc: *****(  " + this.hthHighlyRuralFacilityADCDataQuery + "  )*****"));
            LOGGER.debug((Object)(" location: " + location));
            LOGGER.debug((Object)(" startDate: " + startDate));
            LOGGER.debug((Object)(" endDate: " + endDate));
        }
        List results = null;
        try {
            results = this.queryForReportData(query);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in getHighlyRuralFacilityADCData " + e));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("----- Done with stored proc " + this.hthHighlyRuralFacilityADCDataQuery));
        }
        return results;
    }

    public void setHthHighlyRuralFacilityADCDataQuery(String hthHighlyRuralFacilityADCDataQuery) {
        this.hthHighlyRuralFacilityADCDataQuery = hthHighlyRuralFacilityADCDataQuery;
    }
}

