/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.persistence.AbstractReadableReportsPersistenceManager;
import gov.va.med.cds.ars.persistence.CensusTransformData;
import gov.va.med.cds.ars.persistence.ReadableReportsPersistenceManagerInterface;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtCCMReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtCCMReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtCCMReportPersistenceManager
extends AbstractReadableReportsPersistenceManager
implements ReadableReportsPersistenceManagerInterface {
    protected String censusCoCTotalPtCCMReportQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTResponseType performReadReportAggregate(HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
        COCTotalPtCCMReportFilterType filter = aReportFilter.getCoCTotalPtCCMReportFilter();
        XMLGregorianCalendar xmlStartDate = filter.getStartDate();
        XMLGregorianCalendar xmlEndDate = filter.getEndDate();
        java.sql.Date sqlStartDate = this.formatDate(xmlStartDate);
        java.sql.Date sqlEndDate = this.formatDate(xmlEndDate);
        List results = null;
        try (Session aSession = this.sessionFactory.getCurrentSession();){
            Query query = aSession.getNamedQuery(this.censusCoCTotalPtCCMReportQuery);
            String location = filter.getGeographicalArea().getLocation();
            String vendor = filter.getVendor();
            query.setDate("startDate", (Date)sqlStartDate);
            query.setDate("endDate", (Date)sqlEndDate);
            query.setString("geographicalArea", location);
            query.setString("vendor", vendor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("========== Calling CensusCoCTotalPtCCMReport query procedure: " + this.censusCoCTotalPtCCMReportQuery + " ======"));
                LOGGER.debug((Object)(" CensusCoCTotalPtCCMReport   startDate: '" + sqlStartDate + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtCCMReport   endDate: '" + sqlEndDate + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtCCMReport   geographicalArea location: '" + location + "'"));
                LOGGER.debug((Object)(" CensusCoCTotalPtCCMReport   vendor: '" + vendor + "'"));
            }
            results = this.queryForReportData(query);
        }
        List<GeographicalAreaVendorPatientCountDataType> listData = null;
        listData = CensusTransformData.transformDataProcess(results);
        COCTotalPtCCMReportDataType data = new COCTotalPtCCMReportDataType();
        data.getGeographicalAreaData().addAll(listData);
        data.setReportID(filter.getReportID());
        this.responseType.setCoCTotalPtCCMReportData(data);
        return this.responseType;
    }

    public void setcensusCoCTotalPtCCMReportQuery(String acensusCoCTotalPtCCMReportQuery) {
        this.censusCoCTotalPtCCMReportQuery = acensusCoCTotalPtCCMReportQuery;
    }
}

